<?php

namespace Workdo\Stripe\Providers;

use App\Models\WorkSpace;
use Illuminate\Support\ServiceProvider;

class WaterParkServiceProvider extends ServiceProvider
{
    /**
     * Register the service provider.
     *
     * @return void
     */

    public function boot(){
        view()->composer(['water-park-management::frontend.booking'], function ($view)
        {
                $slug = \Request::segment(3);
                $workspace = WorkSpace::where('slug',$slug)->first();
                $company_settings = getCompanyAllSetting($workspace->created_by,$workspace->id);
                if((module_is_active('Stripe', $workspace->created_by, $workspace->id) && isset($company_settings['stripe_is_on']) ? $company_settings['stripe_is_on'] : 'off') == 'on' && !empty($company_settings['stripe_key']) && !empty($company_settings['stripe_key']) && !empty($company_settings['stripe_secret']) )

                {
                    $view->getFactory()->startPush('waterpark_payment', view('stripe::payment.waterpark_payment',compact('slug')));
                }
        });
    }

    public function register()
    {
        //
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return [];
    }
}
